document.addEventListener("DOMContentLoaded", () => {
  const imagesContainer = document.querySelector("#images-container");
  const mainPage = document.querySelector("#main-page");
  const subPage = document.querySelector("#sub-page");
  const subPageImage = document.querySelector("#sub-page-image");
  const backButton = document.querySelector("#back-button");

  const currentPath = window.location.pathname;
  const storageRef = firebase.storage().ref("pictures");

  try {
    firebase.app();

    function addImageToContainer(url, name) {
      const imageItem = document.createElement("div");
      imageItem.className = "image-item";
      const img = document.createElement("img");
      img.src = url;
      img.alt = name;

      img.addEventListener("click", () => {
        subPageImage.src = url;
        showSubPage();
        console.log(`Image clicked: ${name}`);
        window.history.pushState({ page: "subpage" }, "/", name);
      });

      imageItem.appendChild(img);
      imagesContainer.appendChild(imageItem);
    }

    function sortImagesByDate(images) {
      return images.sort((a, b) => {
        const dateA = getDateFromName(a.name);
        const dateB = getDateFromName(b.name);
        return dateA - dateB;
      });
    }

    function getDateFromName(name) {
      const filename = name.split(".")[0]; // Remove file extension
      const dateStr = filename.split("_")[0]; // Assuming date is before an underscore (_)
      const [year, month, day] = dateStr.split("-");
      const [hour, minute, second] = filename.split("_")[1].split("-");
      return new Date(year, month - 1, day, hour, minute, second);
    }

    function showSubPage() {
      mainPage.style.display = "none";
      subPage.style.display = "block";
    }

    function showMainPage() {
      mainPage.style.display = "block";
      subPage.style.display = "none";
    }

    backButton.addEventListener("click", () => {
      console.log("Back button clicked");
      showMainPage();
      window.history.pushState({ page: "main" }, "", "/");
    });

    window.addEventListener("popstate", (event) => {
      if (!event.state || event.state.page !== "subpage") {
        showMainPage();
      } else {
        showSubPage();
      }
    });

    if (currentPath === "/") {
      loadAllImages();
      updateImages();
    } else {
      console.log(`Current path: ${currentPath}`);
      const filename = currentPath.substring(1);
      if (filename) {
        const imageRef = storageRef.child(filename);

        imageRef
          .getDownloadURL()
          .then((url) => {
            subPageImage.src = url;
            showSubPage();
            loadAllImages();
            updateImages();
          })
          .catch((error) => {
            console.error(error);
          });
      } else {
        console.log("Invalid route");
      }
    }
  } catch (error) {
    console.error(error);
  }

  // function loadAllImages() {
  //   storageRef
  //     .listAll()
  //     .then((result) => {
  //       const sortedImages = sortImagesByDate(result.items);
  //       sortedImages.forEach((itemRef) => {
  //         itemRef
  //           .getDownloadURL()
  //           .then((url) => {
  //             addImageToContainer(url, itemRef.name);
  //           })
  //           .catch((error) => {
  //             console.error(error);
  //           });
  //       });
  //     })
  //     .catch((error) => {
  //       console.error(error);
  //     });
  // }
  function loadAllImages() {
    storageRef
      .listAll()
      .then((result) => {
        const allItems = result.items;
  
        const sortedItems = allItems.sort((a, b) => {
          const dateA = extractDateFromName(a.name);
          const dateB = extractDateFromName(b.name);
          return dateB.getTime() - dateA.getTime();
        });
  
        const newestItems = sortedItems.slice(0, 20);
        // const newestItems = sortedItems;

        newestItems.forEach((itemRef) => {
          itemRef
            .getDownloadURL()
            .then((url) => {
              addImageToContainer(url, itemRef.name);
            })
            .catch((error) => {
              console.error(error);
            });
        });
      })
      .catch((error) => {
        console.error(error);
      });
  }
  
  function extractDateFromName(name) {
    const dateString = name.split('.')[0]; // Remove the file extension
    const [date, time] = dateString.split('_');
    const [year, month, day] = date.split('-');
    const [hours, minutes, seconds] = time.split('-');
  
    // Adjust month value to be zero-based (January is 0, February is 1, etc.)
    const adjustedMonth = month - 1;
  
    return new Date(year, adjustedMonth, day, hours, minutes, seconds);
  }
  
  

  // function updateImages() {
  //   setInterval(() => {
  //     storageRef
  //       .listAll()
  //       .then((result) => {
  //         const sortedImages = sortImagesByDate(result.items);
  //         sortedImages.forEach((itemRef) => {
  //           itemRef
  //             .getDownloadURL()
  //             .then((url) => {
  //               const existingImage = document.querySelector(
  //                 `img[src="${url}"]`
  //               );
  //               if (!existingImage) {
  //                 addImageToContainer(url, itemRef.name);
  //               }
  //             })
  //             .catch((error) => {
  //               console.error(error);
  //             });
  //         });
  //       })
  //       .catch((error) => {
  //         console.error(error);
  //       });
  //   }, 5000);
  // }
  // function updateImages() {
  //   setInterval(() => {
  //     storageRef
  //       .list({ maxResults: 1, orderBy: { field: 'timeCreated', direction: 'DESCENDING' } })
  //       .then((result) => {
  //         const latestImageRef = result.items[0];
  //         latestImageRef
  //           .getDownloadURL()
  //           .then((url) => {
  //             const existingImage = document.querySelector(`img[src="${url}"]`);
  //             if (!existingImage) {
  //               addImageToContainer(url, latestImageRef.name);
  //             }
  //           })
  //           .catch((error) => {
  //             console.error(error);
  //           });
  //       })
  //       .catch((error) => {
  //         console.error(error);
  //       });
  //   }, 5000);
  // }
  
});
