#include <ezButton.h>

ezButton buttonA(22);  // create ezButton object that attach to pin;
ezButton buttonB(23);  // create ezButton object that attach to pin;
ezButton buttonC(24);  // create ezButton object that attach to pin;
//an array for all our sensor pins
int sensorPins[] = {
  0,
  1,
  2,
  3,
  4,
  5,
  6,
  7,
  8
};
//movedFrom
int movedFrom = 0;
//movedTo
int movedTo = 0;
unsigned long previousTime = 0;       // Variable to store the previously recorded time
const unsigned long interval = 1000;  // 1 second interval

//the amount of sensors
const int numSensors = 9;

//in this array we will be keeping all the light levels of the leds
int lightLevel[numSensors], high = 0, low = 1023;

void setup() {
  Serial.begin(9600);           // open the serial port at 9600 bps:
  buttonA.setDebounceTime(25);  // set debounce time to 50 milliseconds
  buttonB.setDebounceTime(25);  // set debounce time to 50 milliseconds
  buttonC.setDebounceTime(25);  // set debounce time to 50 milliseconds
}

void loop() {
  unsigned long currentTime = millis();  // Get the current time

  buttonA.loop();  // MUST call the loop() function first

  if (buttonA.isPressed())
    Serial.println("$,A");

  if (buttonA.isReleased())
    Serial.println("The button is released A");

  buttonB.loop();  // MUST call the loop() function first

  if (buttonB.isPressed())
     Serial.println("$,B");

  if (buttonB.isReleased())
    Serial.println("The button is released B");

  buttonC.loop();  // MUST call the loop() function first

  if (buttonC.isPressed())
    Serial.println("$,C");

  if (buttonC.isReleased())
    Serial.println("The button is released C");
  // Just as we've done in the past, we'll use the analogRead()
  // function to measure the voltage coming from the photoresistor
  // resistor pair. This number can range between 0 (0 Volts) and
  // 1023 (5 Volts), but this circuit will have a smaller range
  // between dark and light.
  //getting our sensor data
  // Serial.println("[==============]");
  if (currentTime - previousTime >= interval) {
    // At least a second has passed
    previousTime = currentTime;  // Update the previous time

    // Perform your desired actions here
    for (int i = 0; i < numSensors; i++) {
      lightLevel[i] = autoTune(analogRead(sensorPins[i]));  // have the Arduino do the work for us with the autotune!
    }
    // Send all sensor values as a single string with a delimiter
    Serial.print("@");
    Serial.print(",");
    for (int i = 0; i < numSensors; i++) {
      // Serial.print(" sensor: ");
      // Serial.print(i);
      // Serial.print(" ");
      Serial.print(lightLevel[i]);
      if (i < numSensors - 1) {
        Serial.print(",");
      } else {
        Serial.print(",");
        Serial.println(moveChecker());
      }
    }

    // delay(1000);  // 1000 milliseconds = 1 second, otherwise it's too fast for me :(
  }
}

String moveChecker() {
  // Find the sensor with the highest value
  int maxSensorValue = lightLevel[0];
  int maxSensorValuePos = 0;
  for (int sensorIndex = 1; sensorIndex < numSensors; sensorIndex++) {
    if (lightLevel[sensorIndex] > maxSensorValue) {
      maxSensorValue = lightLevel[sensorIndex];
      maxSensorValuePos = sensorIndex;
    }
  }

  //as soon as a higher value from a different pin is read we have detected movement
  //checking if the hole has moved since our last reading
  if (movedFrom != maxSensorValuePos) {
    // Serial.println("========");
    // Serial.print("The hole has moved from ");
    // Serial.print(movedFrom);
    // Serial.print(" To: ");
    // Serial.println(maxSensorValuePos);
    // Serial.print("Which means that the piece has moved from ");
    // Serial.print(maxSensorValuePos);
    // Serial.print(" To: ");
    // Serial.print(movedFrom);

    //communicate this to our program
    // call the direction function to get the direction
    String dir = direction(movedFrom, movedTo);

    // send the direction through serial
    movedFrom = movedTo;
    movedTo = maxSensorValuePos;
    return dir;
  } else {
    return "No change";
  }
}

// function to calculate the direction between two numbers in a 3 by 3 grid
String direction(int num1, int num2) {
  int row1 = num1 / 3;  // row of num1 (0-indexed)
  int col1 = num1 % 3;  // column of num1 (0-indexed)
  int row2 = num2 / 3;  // row of num2 (0-indexed)
  int col2 = num2 % 3;  // column of num2 (0-indexed)

  if (row1 == row2 && col1 == col2) {
    return "same so therefore invalid";
  } else if (row1 == row2 && col1 < col2) {
    return "RIGHT";
  } else if (row1 == row2 && col1 > col2) {
    return "LEFT";
  } else if (row1 < row2 && col1 == col2) {
    return "DOWN";
  } else if (row1 > row2 && col1 == col2) {
    return "UP";
  } else {
    return "invalid input";
  }
}


int autoTune(int lightLevelAuto) {
  // As we mentioned above, the light-sensing circuit we built
  // won't have a range all the way from 0 to 1023. It will likely
  // be more like 300 (dark) to 800 (light).

  // In this function, the Arduino will keep track of the highest
  // and lowest values that we're reading from analogRead().

  // If you look at the top of the sketch, you'll see that we've
  // initialized "low" to be 1023. We'll save anything we read
  // that's lower than that:

  if (lightLevelAuto < low) {
    low = lightLevelAuto;
  }

  // We also initialized "high" to be 0. We'll save anything
  // we read that's higher than that:

  if (lightLevelAuto > high) {
    high = lightLevelAuto;
  }

  // Once we have the highest and lowest values, we can stick them
  // directly into the map() function. No manual tweaking needed!

  // One trick we'll do is to add a small offset to low and high,
  // to ensure that the LED is fully-off and fully-on at the limits
  // (otherwise it might flicker a little bit).

  lightLevelAuto = map(lightLevelAuto, low + 30, high - 30, 0, 255);
  // Now we'll return to the main loop(), and send lightLevel
  // to the LED.
  return constrain(lightLevelAuto, 0, 255);
}