import time
import serial

# Define the grid corresponding to the LDRs
grid = [[0, 1, 2], [3, 4, 5], [6, 7, 8]]

# Initialize the serial connection
ser = serial.Serial('COM7', 9600)  # Replace 'COM1' with the appropriate serial port

# Function to read the sensor values from the serial connection
def read_sensor_values():
    while True:
        data = ser.readline().decode().strip()
        if data.startswith('@'):
            sensor_values = data.split(',')[1:-1]  # Extract the sensor values
            return [int(value) for value in sensor_values]

# Function to check LDRs one by one
def check_ldrs():
    for row in grid:
        for col in row:
            # Prompt the user to cover the current sensor
            print(f"Cover the sensor at position ({col//3}, {col%3})")
            input("Press Enter when ready...")
            
            # Wait for 2 seconds
            time.sleep(2)
            
            # Read the sensor values
            sensor_values = read_sensor_values()
            
            # Display the sensor value for the current sensor
            print(f"Sensor value for sensor ({col//3}, {col%3}): {sensor_values[col]}")
            
            # Prompt the user to uncover the current sensor
            print(f"Uncover the sensor at position ({col//3}, {col%3})")
            input("Press Enter when ready...")
            
            # Wait for 2 seconds
            time.sleep(2)
            
            # Read the sensor values
            sensor_values = read_sensor_values()
            
            # Display the sensor value for the current sensor
            print(f"Sensor value for sensor ({col//3}, {col%3}): {sensor_values[col]}")
            # Wait for 2 seconds
            time.sleep(2)

# Main program
if __name__ == '__main__':
    check_ldrs()
