import cv2
import numpy as np
from pynput import keyboard
import subprocess
import sys

# Initialize the camera
cap = cv2.VideoCapture(0)

# Get the camera resolution
width = int(cap.get(cv2.CAP_PROP_FRAME_WIDTH))
height = int(cap.get(cv2.CAP_PROP_FRAME_HEIGHT))

# Calculate the size of the square image
size = min(width, height)

# Calculate the size of the black bars
bar_size = (width - size) // 2

# Create a fullscreen window
cv2.namedWindow("Capture", cv2.WINDOW_NORMAL)
cv2.setWindowProperty("Capture", cv2.WND_PROP_FULLSCREEN,
                      cv2.WINDOW_FULLSCREEN)

# Define a function to take a picture and save it to disk


def take_picture():
    print("Taking picture...")
    ret, frame = cap.read()
    frame = cv2.flip(frame, 1)

    # Crop the image to a square shape
    crop_x = bar_size
    crop_y = 0
    frame = frame[crop_y:crop_y+size, crop_x:crop_x+size]

    cv2.imwrite("picture.jpg", frame)

    # Split the image into 9 tiles
    img = cv2.imread("picture.jpg")
    sections = np.split(img, 3, axis=1)
    tiles = []
    for section in sections:
        horizontal_tiles = np.split(section, 3, axis=0)
        for tile in horizontal_tiles:
            tiles.append(tile)
    for i, tile in enumerate(tiles):
        cv2.imwrite(f"tile_{i}.jpg", tile)

    # subprocess.Popen(["python", "originalCode.py"])

    # Clean up
    cv2.destroyAllWindows()
    cap.release()
    sys.exit()
# # Display the picture with black bars
# picture = np.zeros((height, width, 3), np.uint8)
# picture[:, bar_size:bar_size+size] = frame
# # cv2.imshow("Picture", picture)


# Define a function to handle key presses
def on_press(key):
    try:
        print("Key pressed:", key)
        # If the x key is pressed, take a picture
        if key.char == 'x':
            take_picture()
    except AttributeError:
        pass


# Create a keyboard listener
listener = keyboard.Listener(on_press=on_press)
listener.start()
print("Started listening...")

# Start the main loop
while True:
    # Read a frame from the camera
    ret, frame = cap.read()

    # Flip the image horizontally (mirror effect)
    frame = cv2.flip(frame, 1)

    # Add black bars to the frame
    black_bars = np.zeros((height, bar_size, 3), np.uint8)
    frame = np.concatenate((black_bars, frame, black_bars), axis=1)

    # Display the frame in the window
    cv2.imshow("Capture", frame)

    # Exit the loop if the Esc key is pressed
    if cv2.waitKey(1) == 27:
        break

# Clean up
cv2.destroyAllWindows()
cap.release()
