# DONE test if the movement is correct with how the physical puzzle is moved
# DONE make it so stuff happens when they finish the puzzle: Display congratulations, show the picture again, show the qr code again
# TODO let users decide if they want to retake the picture or if this one is good enough for the game
# TODO make sure that the user can choose to upload their picture or not
# DONE clear the serialbuffer before starting the game because we don't want to have old data in there
# DONE talk with Lahore about actual pretty filters
# DONE make sure that we have a nice shift-it background
# TODO put this in order of importance and sort them
# DONE show a timer on the screen
# DONE show the amount of moves on the screen
# KINDA DONE fix the website so it isn't ugly af
# DONE make sure that the website displays the pictures in the correct order
# DONE implement a sliding animation for the puzzle pieces
# DONE make the actual game window only launch after we have done all the picture stuff
# DONE make sure that you can also select no filter
# DONE use our read sensor data function more
# DONE figure out if the directions should be calculated here or in the arduino because of the shuffeling going on
# DONE send the taken pictures to the firebase and make them be displayed on a website
# DONE add filters and make sure the picture can be taken by pressing X and one of the arduino buttons
# DONE make sure that the user can scan a qr code to get the picture
# DONE for real this time ;) fix the camera perspective when taking a picture
# DONE make sure that the part where the hole is is also the blank space in the puzzle
# DONE make sure that the puzzle is always solvable
# DONE make the game work with the input from the arduino buttons

# basic library imports pygame and random
import pygame
import sys
import random
from pygame.locals import *
import serial
import cv2
import numpy as np
from pynput import keyboard
from datetime import datetime
import os
import time
import asyncio

# progress bar
from tqdm import tqdm

# qr code imports
import qrcode
from io import BytesIO

# firebase imports
import firebase_admin
from firebase_admin import credentials
from firebase_admin import storage

cred = credentials.Certificate(
    'shift-it-a4acc-firebase-adminsdk-juktz-53fc8420da.json')
firebase_admin.initialize_app(cred, {
    'storageBucket': 'shift-it-a4acc.appspot.com'
})


# Initialize the camera
cap = cv2.VideoCapture(0)
cap.set(cv2.CAP_PROP_FRAME_WIDTH, 1280)
cap.set(cv2.CAP_PROP_FRAME_HEIGHT, 720)

# Get the camera resolution
camWidth = int(cap.get(cv2.CAP_PROP_FRAME_WIDTH))
camHeight = int(cap.get(cv2.CAP_PROP_FRAME_HEIGHT))

# Calculate the size of the square image
size = min(camWidth, camHeight)

# Calculate the size of the black bars
bar_size = (camWidth - size) // 2

# Variables for Puzzle Game
columns = 3  # total number of columns in the board of Puzzle Game In Python
rows = 3  # total number of rows in the board
block_size = 240  # size of the block in the board
tiles = []
blank_tile = ""
FPS = 30
BLANK = 0
picture_taken = False
takePictureInMain = False
totalMoves = 0


# Open serial port at a specific baud rate
ser = serial.Serial('COM9', 9600)  # replace with your port name and baud rate its 9 for the leonardo and 7 for the mega

lastDirection = ''
boardCorrectBlank = []
totalMoves = 0
picUrl = 'https://shift-it-a4acc.web.app/' #default link to the website, gets replaced with the actual link later
movedTo = ''
movedFrom = ''
debug = False
startTimer = True
start_time = 0
# Colors and text size
BLACK = (0, 0, 0)
WHITE = (255, 255, 255)
BRIGHTBLUE = (0, 50, 255)
BGCOLOR = (252, 103, 74)
TEXTCOLOR = WHITE
BASICFONTSIZE = 20

GAMEWIDTH = 640
GAMEHEIGHT = 480
XMARGIN = 0
YMARGIN = 0
BASICFONT = 'freesansbold.ttf'
#create the window for the camera feed
cv2.namedWindow("Capture", cv2.WINDOW_NORMAL)
cv2.setWindowProperty("Capture", cv2.WND_PROP_FULLSCREEN,
                      cv2.WINDOW_FULLSCREEN)

# filter
current_filter = None

'Define a function to handle key presses'
def on_press(key):
    try:
        print("Key pressed:", key)
        # If the x key is pressed, take a picture
        if key.char == 'x':
            global takePictureInMain
            takePictureInMain = True
        # cheating to finish the game
        if key.char == 'c':
            print('cheating')
            show_end_stage()
        if key.char == '1':
            print("Exiting...")
            check_exit_req()
        if key.char == '4':
            cycle_filters(direction=1)
        if key.char == '6':
            cycle_filters(direction=-1)
    except AttributeError:
        pass

# Create a keyboard listener
listener = keyboard.Listener(on_press=on_press)
listener.start()
print("Started listening...")

# this is the main function


async def main():
    global FPSCLOCK, DISPLAYSURF, BASICFONT, picture_taken, startTimer, start_time, totalMoves, takePictureInMain
    
    # Initialize a flag variable outside the while loop
    hasExecuted = False
    # take the picture first then handle all the main game logic
    while True:
        if not picture_taken:
            # Read a frame from the camera
            ret, frame = cap.read()
            if not ret:
                continue
            # Flip the image horizontally (mirror effect)
            frame = cv2.flip(frame, 1)

            # Crop the image to a square shape
            crop_x = bar_size
            crop_y = 0
            frameDisplay = frame[crop_y:crop_y+size, crop_x:crop_x+size]
            # Create a black image of the same size as the frame
            black_image = np.zeros_like(frame)
            # Calculate the coordinates for centering the cropped image
            center_x = (black_image.shape[1] - frameDisplay.shape[1]) // 2
            center_y = (black_image.shape[0] - frameDisplay.shape[0]) // 2
            # Copy the frame onto the black image
            black_image[center_y:center_y+frameDisplay.shape[0],
                        center_x:center_x+frameDisplay.shape[1]] = frameDisplay

            # Update the frame variable with the modified image
            frame = black_image

            global current_filter
            # Apply the selected filter (if any)
            frame = check_filter(frame)
            
            # Display the frame in the window
            cv2.imshow("Capture", frame)

            # Check if we got a button press through our serial communication
            if ser.in_waiting > 0:
                data = ser.readline().decode().strip()  # Read the serial data
                # make sure we have the correct checksum for the button press
                # We have 3 buttons A B C, the codes for them will look like this:
                # $,A $,B $,C
                button_data = data.split(",")
                print(button_data)
                if takePictureInMain: #this only exists for testing on the laptop it's a bit of a hack
                    await take_picture()
                    takePictureInMain = False
                    picture_taken = True
                if button_data[0] == '$':
                    print("correct checksum")
                    print(button_data)
                    if button_data[1] == 'A':
                        print("A pressed")
                        await take_picture()
                        picture_taken = True
                    elif button_data[1] == 'B':
                        cycle_filters(direction=1)
                    elif button_data[1] == 'C':
                        cycle_filters(direction=-1)

            # Exit the loop if the Esc key is pressed
            if cv2.waitKey(1) == 27:
                break

        else:
            if not hasExecuted:
                # initialize the game
                pygame.init()

                FPSCLOCK = pygame.time.Clock()
                # Set display flags for fullscreen and borderless
                flags = pygame.FULLSCREEN | pygame.NOFRAME
                # Set the display mode
                DISPLAYSURF = pygame.display.set_mode((0, 0), flags)
                # DISPLAYSURF.set_alpha(None)
                # Hide the mouse cursor
                pygame.mouse.set_visible(False)
                global GAMEWIDTH, GAMEHEIGHT, XMARGIN, YMARGIN, BASICFONT
                GAMEWIDTH, GAMEHEIGHT = pygame.display.get_surface().get_width(
                ), pygame.display.get_surface().get_height()

                # this is to leave the space on both the sides of the block
                XMARGIN = int((GAMEWIDTH - (block_size * columns)) / 2)
                YMARGIN = int((GAMEHEIGHT - (block_size * rows)) / 2)
                # we gave a title using set_caption function in pygame
                pygame.display.set_caption('Slide Puzzle')
                BASICFONT = pygame.font.Font('freesansbold.ttf', BASICFONTSIZE)
                DISPLAYSURF.fill(BGCOLOR)
                backgroundImg = pygame.image.load('img/background.jpg')

                # Scale the background image to fit the display surface without stretching
                backgroundImg = pygame.transform.scale(backgroundImg, (GAMEWIDTH, GAMEHEIGHT))

                # Blit the background image onto the display surface
                DISPLAYSURF.blit(backgroundImg, (0, 0))
                # close the picture window
                cap.release()
                cv2.destroyWindow('Capture')
                print("Starting game...")
                # Set the flag variable to True to indicate that the code has been executed so we don't execute it again
                hasExecuted = True
                allMoves = []
                # Load the tile images
                indexes = [0, 1, 2, 3, 4, 5, 6, 7, 8]
                for i in indexes:
                    tile_img = pygame.image.load(
                        f"img/tile_{indexes[i]}.jpg").convert()
                    tiles.append(tile_img)
                    # print(tiles)
                global blank_tile
                blank_tile = pygame.image.load('img/blank.png').convert()
                # this number is the number of moves to shuffle the board
                board, sequence = await generate_new_puzzle(10)
                boardCorrectBlank = await move_blank_spot(board)
                if debug:
                    print_board(boardCorrectBlank)
                draw_board(boardCorrectBlank)
                pygame.display.update()

                SOLVEDBOARD = get_board()
                slideTo = None
                # clear the serial buffer before we start the game
                ser.reset_input_buffer()
                check_exit_req()
            else:
                if boardCorrectBlank == SOLVEDBOARD:
                    print('Solved')
                    show_end_stage()
                else:
                    update_timer()
                    # getting our data from the sensors from the pyhiscal puzzle
                    sensor_values, slideTo = await read_sensor_data()
                    if debug:
                        # displaying for debugging purposes
                        display_sensor_values(sensor_values, slideTo)
                    # make sure we can still quit the game
                    check_exit_req()

                    if is_valid_move(boardCorrectBlank, slideTo):
                        if startTimer:
                            start_time = pygame.time.get_ticks()
                            startTimer = False
                        print('we are going to move the block')
                        await sliding_animation(boardCorrectBlank, slideTo, 10)
                        boardCorrectBlank = await swap_block(
                            boardCorrectBlank, slideTo, True)
                        allMoves.append(slideTo)
                        totalMoves = len(allMoves)
                        print_text(f"Total Moves: {totalMoves}")
                        draw_board(boardCorrectBlank)
                        update_timer()
            pygame.display.update()
            FPSCLOCK.tick(FPS)
            
def update_timer():
    if not startTimer:
        end_time = pygame.time.get_ticks()
        elapsed_time = end_time - start_time

        # Convert elapsed time to minutes and seconds
        minutes = elapsed_time // 60000
        seconds = (elapsed_time % 60000) // 1000

        font = pygame.font.Font(None, 36)  # Choose the desired font and size
        pygame.draw.rect(DISPLAYSURF, BGCOLOR, (26, 100, 300, 55))  # Erase previous text
        text_surface = font.render(f"Elapsed Time: {minutes:02d}:{seconds:02d}", True, WHITE)
        DISPLAYSURF.blit(text_surface, (26, 100))

# logically speaking this function is correct, but we are kinda limited by the output of our sensors.
# Maybe it will work better with the actual prototype because of less light bleeding?
async def move_blank_spot(board):
    index = await find_index_blank_spot_from_sensors()
    blank_row, blank_col = get_block_pos(board, 0)
    block_row, block_col = get_block_pos_by_index(index)

    if blank_row == block_row and blank_col == block_col:
        if debug:
            print_text('blank spot is already in the correct position')
        return board

    if debug:
        print_text('blank spot is not in the correct position, attempting to fix desync')

    board = swap_blocks(board, blank_row, blank_col, block_row, block_col)

    if solvable(board):
        return board

    if debug:
        print('the board was not solvable after the initial move')
        print_board(board)

    board = ensure_solvable(board, block_row, block_col)

    return board

async def find_index_blank_spot_from_sensors():
    # Read sensor data and find the highest sensor value
    sensor_values, dir = await read_sensor_data()
    highest_sensor_value = max(sensor_values)
   
    # Find the index of the highest sensor value on the board
    index = sensor_values.index(highest_sensor_value)
    if debug:
        print('these are the sensor values')
        print(sensor_values)
        print('this is the index of the highest sensor value' + str(index))
        print(sensor_values[index])
    return index


async def read_sensor_data():
    while True:
        if ser.in_waiting > 0:
            data = ser.readline().decode().strip()
            sensor_values = data.split(",")
            if sensor_values[0] == '@':
                direction = sensor_values[-1]
                sensor_values = sensor_values[1:-1]
                return [int(num) for num in sensor_values], direction
        await asyncio.sleep(0.1)  # Add a small delay before retrying


def swap_blocks(board, row1, col1, row2, col2):
    # Swap the blocks in the board
    board[row1][col1], board[row2][col2] = board[row2][col2], board[row1][col1]
    return board


def ensure_solvable(board, block_row, block_col):
    directions = [(-1, 0), (1, 0), (0, -1), (0, 1)]

    for dr, dc in directions:
        new_row, new_col = block_row + dr, block_col + dc

        if is_valid_position(board, new_row, new_col):
            print(
                'the blank was placed in a spot that made the puzzle unsolvable, lets fix that ')

            board = swap_blocks(board, new_row, new_col, block_row, block_col)

            if solvable(board):
                return board

            board = swap_blocks(board, new_row, new_col, block_row, block_col)

    return board


def is_valid_position(board, row, col):
    return 0 <= row < len(board) and 0 <= col < len(board[0])


def terminate():
    pygame.quit()
    sys.exit()


def show_end_stage():
    # Color the screen black
    DISPLAYSURF.fill(BGCOLOR)

    # Render and blit the text thanking the user for playing
    text = BASICFONT.render("Thanks for playing!", True, WHITE)
    text_rect = text.get_rect(center=(GAMEWIDTH/2 + 400, GAMEHEIGHT/2 - 150))
    DISPLAYSURF.blit(text, text_rect)

    # Display the QR code to the website with their picture
    make_QR_code(picUrl)  # The data to encode in the QR code

    # Render and blit the text instructing the user to go to the website
    text = BASICFONT.render("Go to the website to download your picture!", True, WHITE)
    text_rect = text.get_rect(center=(GAMEWIDTH/2 + 400, GAMEHEIGHT/2 - 100))
    DISPLAYSURF.blit(text, text_rect)

    # Display the picture on the left side
    gameImg = pygame.image.load('img/picture.jpg').convert()
    DISPLAYSURF.blit(gameImg, (GAMEWIDTH/2 - 700, GAMEHEIGHT/2 - 350))

    # Calculate the time it took to solve the puzzle
    end_time = pygame.time.get_ticks()
    elapsed_time = end_time - start_time

    # Convert elapsed time to minutes and seconds
    minutes = elapsed_time // 60000
    seconds = (elapsed_time % 60000) // 1000

    # Render and blit the total number of moves and time taken
    text_moves = BASICFONT.render("Total Moves: " + str(totalMoves), True, WHITE)
    text_time = BASICFONT.render("Total Time: " + str(minutes) + ":" + str(seconds), True, WHITE)

    text_rect_moves = text_moves.get_rect(center=(GAMEWIDTH/2 + 400, GAMEHEIGHT/2 + 300))
    text_rect_time = text_time.get_rect(center=(GAMEWIDTH/2 + 400, GAMEHEIGHT/2 + 350))

    DISPLAYSURF.blit(text_moves, text_rect_moves)
    DISPLAYSURF.blit(text_time, text_rect_time)

    # Update only the necessary areas of the screen
    pygame.display.update([text_rect, text_rect_moves, text_rect_time])

    # Wait for 15 seconds
    pygame.time.wait(15000)

    # Exit the game
    terminate()


def make_QR_code(data):
    qr = qrcode.QRCode(
        version=1, error_correction=qrcode.constants.ERROR_CORRECT_H, box_size=7, border=3)
    qr.add_data(data)
    qr.make(fit=True)
    qr_image = qr.make_image(
        fill_color="black", back_color="white")
    # Convert the QR code image to a Pygame surface
    byte_stream = BytesIO()
    qr_image.save(byte_stream, "PNG")
    byte_stream.seek(0)
    qr_surface = pygame.image.load(byte_stream)
    # Calculate the position of the QR to center it
    qr_rect = qr_surface.get_rect()
    qr_rect.center = (GAMEWIDTH/2+400, GAMEHEIGHT/2 + 100)

    # Draw the QR code on the screen
    DISPLAYSURF.blit(qr_surface, qr_rect)


def solvable(board):
    # There has to be a better way to do this?
    # our board is a 3x3 matrix so we can flatten it to a 1x9 matrix
    # we will use the following notation for the board
    # 1 2 3
    # 4 5 6
    # 7 8 0
    # we will flatten it to 012345678
    # print(board)
    tiles = []
    for i in range(3):
        for j in range(3):
            tiles.append(board[i][j])
    # print(tiles)
    """
    https://datawookie.dev/blog/2019/04/sliding-puzzle-solvable/ 
    Check whether a 3x3 sliding puzzle is solvable.
    Checks the number of "inversions". If this is odd then the puzzle configuration is not solvable.
    An inversion is when two tiles are in the wrong order.
    For example, the sequence 1, 3, 4, 7, 0, 2, 5, 8, 6 has six inversions:
    3 > 2
    4 > 2
    7 > 2
    7 > 5
    7 > 6
    8 > 6
    The empty tile is ignored.
    """
    count = 0

    for i in range(8):
        for j in range(i+1, 9):
            if tiles[j] and tiles[i] and tiles[i] > tiles[j]:
                count += 1

    return count % 2 == 0


def check_exit_req():
    # get all the QUIT events
    for event in pygame.event.get(QUIT):
        # terminate() will kill all the events. terminate if any QUIT events are present
        terminate()
    # this for loop will get all the KEYUP events
    for event in pygame.event.get(KEYUP):
        if event.key == K_ESCAPE:
            # if the user presses the ESC key then it will terminate the session and if the KEYUP event was for the Esc key
            terminate()
        # put the other KEYUP event objects back
        pygame.event.post(event)


def get_board():
    # Return a board structure with blocks in the solved state.
    # make the structure of the board
    return [[1, 2, 3], [4, 5, 6], [7, 8, BLANK]]

# who wrote this piece of shit the x and y are switched, it was me :'(
def get_block_pos(board, block):
    # Return the x and y of board coordinates of the block.
    for x in range(3):
        for y in range(3):
            if board[x][y] == block:
                return (x, y)


def get_block_pos_correct(board, block):
    # Return the x and y of board coordinates of the block.
    for y in range(3):
        for x in range(3):
            if board[y][x] == block:
                return (x, y)


def get_block_pos_by_index(index):
    row = index // 3  # Integer division to get the row
    column = index % 3  # Modulo operator to get the column
    return row, column


async def swap_block(matrix, direction, checkForDesync):
    blank_x, blank_y = get_block_pos(matrix, BLANK)
    new_matrix = [row.copy() for row in matrix]  # Create a copy of the matrix

    # Swap the blank spot with the adjacent block based on the specified direction
    if direction == "UP":
        new_matrix[blank_x][blank_y], new_matrix[blank_x -
                                                 1][blank_y] = new_matrix[blank_x - 1][blank_y], new_matrix[blank_x][blank_y]
    elif direction == "DOWN":
        new_matrix[blank_x][blank_y], new_matrix[blank_x +
                                                 1][blank_y] = new_matrix[blank_x + 1][blank_y], new_matrix[blank_x][blank_y]
    elif direction == "LEFT":
        new_matrix[blank_x][blank_y], new_matrix[blank_x][blank_y -
                                                          1] = new_matrix[blank_x][blank_y - 1], new_matrix[blank_x][blank_y]
    elif direction == "RIGHT":
        new_matrix[blank_x][blank_y], new_matrix[blank_x][blank_y +
                                                          1] = new_matrix[blank_x][blank_y + 1], new_matrix[blank_x][blank_y]
    else:
        raise ValueError(
            "Invalid direction. Please use 'UP', 'DOWN', 'LEFT', or 'RIGHT'.")

    # Write an extra function that will be called here to make sure that the blank spot is actually where we expect it to be
    # this will prevent desync bewteen the physical board and the virtual board
    # only do this once the game has started
    if checkForDesync:
        new_matrix = await move_blank_spot(new_matrix)
    return new_matrix


async def sliding_animation(board, direction,  animationSpeed):
    blankx, blanky = get_block_pos_correct(board, BLANK)
    if direction == 'UP':
        move_in_xaxis = blankx
        move_in_yaxis = blanky - 1
    elif direction == 'DOWN':
        move_in_xaxis = blankx
        move_in_yaxis = blanky + 1
    elif direction == 'LEFT':
        move_in_xaxis = blankx - 1
        move_in_yaxis = blanky
    elif direction == 'RIGHT':
        move_in_xaxis = blankx + 1
        move_in_yaxis = blanky

    # prepare the base surface
    draw_board(board)
    baseSurf = DISPLAYSURF.copy()
    # draw a blank space over the moving block on the baseSurf Surface.
    # take_left, take_top = get_left_top_of_block(move_in_xaxis, move_in_yaxis)

    # pygame.time.wait(2000)
    if debug:
        print("direction" + str(direction) + " move in x axis: " + str(move_in_xaxis) +
            " move in y axis: " + str(move_in_yaxis) + " block " + str(board[move_in_yaxis][move_in_xaxis]))
    for i in range(0, block_size, animationSpeed):

        # this is to handle the animation of the tile sliding over
        check_exit_req()
        update_timer()
        DISPLAYSURF.blit(baseSurf, (0, 0))
        if direction == 'UP':
            draw_block(move_in_xaxis, move_in_yaxis, 0)
            draw_block(move_in_xaxis, move_in_yaxis,
                       board[move_in_yaxis][move_in_xaxis], 0, i)
        if direction == 'DOWN':
            draw_block(move_in_xaxis, move_in_yaxis, 0)
            draw_block(move_in_xaxis, move_in_yaxis,
                       board[move_in_yaxis][move_in_xaxis], 0, -i)
        if direction == 'LEFT':
            draw_block(move_in_xaxis, move_in_yaxis, 0)
            draw_block(move_in_xaxis, move_in_yaxis,
                       board[move_in_yaxis][move_in_xaxis], i, 0)
        if direction == 'RIGHT':
            draw_block(move_in_xaxis, move_in_yaxis, 0)
            draw_block(move_in_xaxis, move_in_yaxis,
                       board[move_in_yaxis][move_in_xaxis], -i, 0)

        pygame.display.update()
        FPSCLOCK.tick(FPS)


def is_valid_move(board, direction):
    blank_x, blank_y = get_block_pos(board, BLANK)
    # Check if the blank spot can be moved in the specified direction
    if direction == "UP":
        return blank_x > 0
    elif direction == "DOWN":
        return blank_x < 2
    elif direction == "LEFT":
        return blank_y > 0
    elif direction == "RIGHT":
        return blank_y < 2
    else:
        # this is totally normal, if we don't get a direction we simply dont move.
        if debug:
            print(direction)
        return False

def random_moves(board, lastMove=None):
    # Check if it's the first move
    if lastMove is None:
        validMoves = []

        # Check each direction for validity
        if is_valid_move(board, 'UP'):
            validMoves.append('UP')
        if is_valid_move(board, 'DOWN'):
            validMoves.append('DOWN')
        if is_valid_move(board, 'LEFT'):
            validMoves.append('LEFT')
        if is_valid_move(board, 'RIGHT'):
            validMoves.append('RIGHT')

        if not validMoves:
            raise ValueError("No valid moves available.")

        return random.choice(validMoves)

    # Start with a full list of all four moves
    validMoves = ['UP', 'DOWN', 'LEFT', 'RIGHT']

    # Remove moves from the list as they are disqualified
    if lastMove == 'UP' or not is_valid_move(board, 'DOWN'):
        validMoves.remove('DOWN')
    if lastMove == 'DOWN' or not is_valid_move(board, 'UP'):
        validMoves.remove('UP')
    if lastMove == 'LEFT' or not is_valid_move(board, 'RIGHT'):
        validMoves.remove('RIGHT')
    if lastMove == 'RIGHT' or not is_valid_move(board, 'LEFT'):
        validMoves.remove('LEFT')

    if not validMoves:
        raise ValueError("No valid moves available.")

    return random.choice(validMoves)


def get_left_top_of_block(block_x, block_y):
    left = XMARGIN + (block_x * block_size) + (block_x - 1)
    top = YMARGIN + (block_y * block_size) + (block_y - 1)
    return (left, top)


def draw_block(block_x, block_y, number, adjx=0, adjy=0):
    left, top = get_left_top_of_block(block_x, block_y)
    if number == 0:
        DISPLAYSURF.blit(blank_tile, (left + adjx, top + adjy))
    else:
        tile_img = tiles[number - 1]
        DISPLAYSURF.blit(tile_img, (left + adjx, top + adjy))
        text_rendering = BASICFONT.render(str(number), True, TEXTCOLOR)
        text_in_rect = text_rendering.get_rect()
        text_in_rect.center = left + \
            int(block_size / 2) + adjx, top + int(block_size / 2) + adjy
        DISPLAYSURF.blit(text_rendering, text_in_rect)

# Function to print text in the top-left corner of the screen
def print_text(text):
    font = pygame.font.Font(None, 36)  # Choose the desired font and size
    # Fill the area with a black color to erase previous text
    pygame.draw.rect(DISPLAYSURF, BGCOLOR, (26, 70, 500, 55))

    # Render the text
    text_surface = font.render(text, True, WHITE)

    # Blit the text surface onto the screen
    DISPLAYSURF.blit(text_surface, (26, 70))


def print_board(board):
    # print the board in console
    print(board[0])
    print(board[1])
    print(board[2])


def draw_board(board):
    for block_x in range(len(board[0])):
        for block_y in range(len(board)):
            draw_block(block_x, block_y, board[block_y][block_x])


def test_valid_moves(board):
    print('this should be false direction right')
    print(is_valid_move(board, 'RIGHT'))
    print('this should be false direction down')
    print(is_valid_move(board, 'DOWN'))
    print('this should be true direction left')
    print(is_valid_move(board, 'LEFT'))
    print('this should be true direction up')
    print(is_valid_move(board, 'UP'))


def test_get_block_pos(board):
    print('Testing get_block_pos function:')
    print('------------------------------')

    print('Finding block 0:')
    pos = get_block_pos(board, 0)
    print('Block 0 position:', pos)
    print('Expected output: None')
    print()

    print('Finding block 5:')
    pos = get_block_pos(board, 5)
    print('Block 5 position:', pos)
    print('Expected output: (1, 1)')
    print()

    print('Finding block 8:')
    pos = get_block_pos(board, 8)
    print('Block 8 position:', pos)
    print('Expected output: (2, 1)')
    print()


async def generate_new_puzzle(numSlides):
    sequence = []
    board = get_board()
    if debug:
        test_get_block_pos(board)
    draw_board(board)
    pygame.display.update()
    pygame.time.wait(500)
    lastMove = None
    for i in range(numSlides):
        
        move = random_moves(board, lastMove)
        if debug:
            print('slide number: ', i, ' last move: ', lastMove)
            print_text('The board is being shuffled ...')
            # test_valid_moves(board)
            print('board before move: ', move)
            print_board(board)
        await sliding_animation(board, move, 10)
        board = await swap_block(board, move, False)
        if debug:
            print('updated board')
            print_board(board)

        sequence.append(move)
        lastMove = move
        draw_board(board)
        pygame.display.update()
    print_text('')
    return (board, sequence)


def display_sensor_values(sensor_values, direction):
    global lastDirection
    text_region = pygame.Rect(GAMEWIDTH-400, 0, 400, 600)
    DISPLAYSURF.fill(BGCOLOR, text_region)
    # Display the sensor values on the top right corner
    x = GAMEWIDTH - 10
    y = 10
    for i, value in enumerate(sensor_values):
        text = BASICFONT.render(
            f"Sensor {i}: {value}", True, (255, 255, 255))
        text_rect = text.get_rect()
        text_rect.topright = (x, y)
        DISPLAYSURF.blit(text, text_rect)
        y += text_rect.height + 5

    if direction == 'UP' or direction == 'DOWN' or direction == 'LEFT' or direction == 'RIGHT':
        lastDirection = direction
        # last direction that we moved in
    text = BASICFONT.render(
        f"Last moved direction: " + lastDirection, True, (255, 255, 255))
    text_rect = text.get_rect()
    text_rect.topright = (x, text_rect.height + 250)
    DISPLAYSURF.blit(text, text_rect)
    #
    # Update the Pygame display
    pygame.display.flip()

def check_filter(frame):
    if current_filter is not None:
        if current_filter in ['9','10', '11', '12', '13','14','15','16']:
            return load_overlay_image(int(current_filter), frame)
        else:
            return filter_functions[current_filter](frame)
    else:
        return frame

async def take_picture():
    print("Taking picture...")
    ret, frame = cap.read()
    frame = cv2.flip(frame, 1)

    # Apply the selected filter (if any)
    frame = check_filter(frame)

    # Crop the image to a square shape
    crop_x = bar_size
    crop_y = 0
    frame = frame[crop_y:crop_y+size, crop_x:crop_x+size]

    success = cv2.imwrite("img/picture.jpg", frame)
    if success:
        print("Image saved successfully.")
    else:
        print("Failed to save the image.")

    global picUrl
    picUrl = await upload_picture()
    # Split the image into 9 tiles
    # img = cv2.imread("img/image.png") for testing
    img = cv2.imread("img/picture.jpg")
    sections = np.split(img, 3, axis=0)
    tiles = []
    for section in sections:
        vertical_tiles = np.split(section, 3, axis=1)
        for tile in vertical_tiles:
            tiles.append(tile)

    # Save the tiles as separate images
    for i, tile in enumerate(tiles):
        cv2.imwrite(f"img/tile_{i}.jpg", tile)
    print("Picture taken!")


async def upload_picture():
    current_datetime = datetime.now()
    destination_path = 'pictures/' + \
        current_datetime.strftime('%Y-%m-%d_%H-%M-%S') + '.jpg'

    bucket = storage.bucket()
    blob = bucket.blob(destination_path)
    blob.upload_from_filename('img/picture.jpg')

    print('Picture uploaded successfully. Destination:', destination_path)
    return 'https://shift-it-a4acc.web.app/' + current_datetime.strftime('%Y-%m-%d_%H-%M-%S') + '.jpg'


def no_filter_function(frame):
    # Return the input frame without any modifications
    return frame


def apply_grayscale(image):
    gray = cv2.cvtColor(image, cv2.COLOR_BGR2GRAY)
    return gray


def apply_sepia(image):
    kernel = np.array([[0.272, 0.534, 0.131],
                       [0.349, 0.686, 0.168],
                       [0.393, 0.769, 0.189]])
    sepia = cv2.transform(image, kernel)
    return sepia


def apply_cartoon(image):
    gray = cv2.cvtColor(image, cv2.COLOR_BGR2GRAY)
    gray = cv2.medianBlur(gray, 5)
    edges = cv2.adaptiveThreshold(
        gray, 255, cv2.ADAPTIVE_THRESH_MEAN_C, cv2.THRESH_BINARY, 9, 9)

    color = cv2.bilateralFilter(image, 9, 300, 300)
    cartoon = cv2.bitwise_and(color, color, mask=edges)
    return cartoon


def apply_invert(image):
    inverted_image = cv2.bitwise_not(image)
    return inverted_image


def apply_blur(image):
    blurred = cv2.GaussianBlur(image, (15, 15), 0)
    return blurred


def apply_edge_detection(image):
    edges = cv2.Canny(image, 100, 200)
    return edges


def apply_emboss(image):
    kernel = np.array([[0, -1, -1],
                       [1, 0, -1],
                       [1, 1, 0]])
    embossed = cv2.filter2D(image, -1, kernel)
    return embossed


def apply_saturation(image, saturation_factor):
    hsv_image = cv2.cvtColor(image, cv2.COLOR_BGR2HSV)
    hsv_image[:, :, 1] = hsv_image[:, :, 1] * saturation_factor
    saturated = cv2.cvtColor(hsv_image, cv2.COLOR_HSV2BGR)
    return saturated

def load_overlay_image(index, frame):
    frame_shape = frame.shape
    overlay_path = 'img/overlay' + str(index-7) + '.png'
    overlay = cv2.imread(overlay_path, cv2.IMREAD_UNCHANGED)
    
    overlay_float = overlay.astype(np.float32) / 255.0
    overlay_resized = cv2.resize(overlay_float, (frame_shape[1], frame_shape[0]), interpolation=cv2.INTER_LINEAR)
    overlay_alpha = overlay_resized[:, :, 3]
    overlay_bgr = overlay_resized[:, :, :3]
    
    return apply_overlay(frame, overlay_bgr, overlay_alpha)

def apply_overlay(frame, overlay_bgr, overlay_alpha):
    frame_float = frame.astype(np.float32) / 255.0
    mask = np.dstack([overlay_alpha, overlay_alpha, overlay_alpha])
    
    result = frame_float * (1.0 - mask) + overlay_bgr * mask
    
    return (result * 255).astype(np.uint8)

filter_functions = {
    'none': no_filter_function,  # Add the "No Filter" option
    '1': apply_grayscale,
    '2': apply_sepia,
    '3': apply_cartoon,
    '4': apply_invert,
    '5': apply_blur,
    '6': apply_edge_detection,
    '7': apply_emboss,
    # Example of applying saturation with a factor of 1.5
    '8': lambda image: apply_saturation(image, 1.5),
    '9': load_overlay_image,
    '10': load_overlay_image,
    '11': load_overlay_image,
    '12': load_overlay_image,
    '13': load_overlay_image,
    '14': load_overlay_image,
    '15': load_overlay_image,
    '16': load_overlay_image,
    # Add more filters and their respective keys here
}
def cycle_filters(direction):
    global current_filter

    filter_keys = list(filter_functions.keys())

    if current_filter is None:
        current_filter = filter_keys[0]
    # Check if current filter is 'none' (No Filter)
    elif current_filter == 'none':
        current_index = filter_keys.index('none')
        current_index = (current_index + direction) % len(filter_keys)
        current_filter = filter_keys[current_index]
    else:
        current_index = filter_keys.index(current_filter)
        current_index = (current_index + direction) % len(filter_keys)
        current_filter = filter_keys[current_index]

    print("Current filter:", current_filter)


# this is the call to main fucntion
asyncio.run(main())